//
//  AHKPhone.h
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on 06/04/21.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
//
//  AirHPhone.h
//  BookmarkUtility
//
//  Created by raktajino on Thu Jun 17 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import <Foundation/Foundation.h>
#import <termios.h>


#define kReadBufferSize			4096					// preferred buffer size for reading
#define kWriteBufferSize		4096					// preferred buffer size for writing


extern NSString *AHKErrorDomain;

enum {
	AHKPhoneNotReadyError = 1,
	AHKPhoneIncorrectPasswordError, 
	AHKPhoneInapplicableDataReceivedError,
	AHKPhoneInapplicablePasswordStringEncodingError, 
	AHKPhoneInapplicablePasswordStringLengthError,
	AHKPhoneNotLoggedInError,
	AHKPhoneMalformedItemReceivedError,
	AHKPhoneMalformedItemSentError,
	AHKPhoneTooManyItemsSendingError,
	AHKPhoneUserCancelledError	
};

@protocol AHKProgressing;

@interface AHKPhone : NSObject {
	int				fileDescriptor;
	struct termios  originalTTYAttrs;
	BOOL			loggedin;
}

+ (BOOL)existsDriver;
+ (NSString *)humanReadableDriverName;

- (BOOL)openError:(NSError **)errorPtr;
- (BOOL)closeError:(NSError **)errorPtr;
- (BOOL)sendCommand:(SInt32)a subCommand:(SInt32)b parameter:(char *)parameter error:(NSError **)errorPtr;
- (BOOL)sendCommand:(SInt32)a subCommand:(SInt32)b parameter:(UInt8 *)parameter length:(SInt32)length error:(NSError **)errorPtr;
- (SInt32)receiveData:(UInt8 *)buffer maxLength:(SInt32)bufferSize additionally:(BOOL)hasAdditionallydata error:(NSError **)errorPtr;
- (SInt32)receiveRawData:(UInt8 *)buffer maxLength:(SInt32)bufferSize error:(NSError **)errorPtr;

- (BOOL)loginWithPassword:(NSString *)password error:(NSError **)errorPtr;

@end
